/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Iterator;

public class SwarmPeerList {
    private static Hashtable<String, Peer> swarmPeerList;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SwarmPeerList() {
        swarmPeerList = new Hashtable();
    }

    public synchronized void handlePeer(Peer peer) {
        if (!swarmPeerList.containsKey(peer.getIP())) {
            swarmPeerList.put(peer.getIP(), peer);
            if (swarmPeerList.size() % 1000 == 0) {
                System.out.println("peers: " + swarmPeerList.size());
            }
        }
    }

    public synchronized void removeFromDB(Peer peer) {
        swarmPeerList.remove(peer.getInetSocketAddress());
    }

    public static synchronized int size() {
        return swarmPeerList.size();
    }

    public synchronized Iterator<String> getIterator() {
        return swarmPeerList.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Peer popPeer(String IP) {
        SwarmPeerList swarmPeerList = this;
        synchronized (swarmPeerList) {
            if (SwarmPeerList.swarmPeerList.containsKey(IP)) {
                return SwarmPeerList.swarmPeerList.remove(IP);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Peer getPeer(String IP) {
        SwarmPeerList swarmPeerList = this;
        synchronized (swarmPeerList) {
            if (SwarmPeerList.swarmPeerList.containsKey(IP)) {
                return SwarmPeerList.swarmPeerList.get(IP);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPort(String IP) {
        SwarmPeerList swarmPeerList = this;
        synchronized (swarmPeerList) {
            if (SwarmPeerList.swarmPeerList.containsKey(IP)) {
                return SwarmPeerList.swarmPeerList.get(IP).getPort();
            }
            return 0;
        }
    }

    public synchronized String xmlPeerList() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<peers>\n");
        Iterator<String> iterator = swarmPeerList.keySet().iterator();
        while (iterator.hasNext()) {
            Peer p = swarmPeerList.get(iterator.next());
            sb.append(this.xmlPeer(p));
        }
        sb.append("\t</peers>\n</crawl>");
        return sb.toString();
    }

    public synchronized String xmlPeer(Peer p) {
        if (p != null) {
            try {
                return "\t\t<peer>\n\t\t\t<ip>" + p.getIP() + "</ip>\n" + "\t\t\t<discovery_time>" + this.sdf.format(p.getDiscDateTime().getTime()) + "</discovery_time>\n" + "\t\t\t<discTracker>" + p.getTrackerDisc() + "</discTracker>\n" + "\t\t\t<discDHT>" + p.getDHTDisc() + "</discDHT>\n" + "\t\t\t<discPEX>" + p.getPEXDisc() + "</discPEX>\n" + "\t\t\t<connected>" + p.isConnected() + "</connected>\n" + "\t\t\t<port>" + p.getPort() + "</port>\n" + "\t\t\t<PEXEncryption>" + p.getPEXEncryptionFlag() + "</PEXEncryption>\n" + "\t\t\t<PEXHolepunch>" + p.getPEXHolepunchFlag() + "</PEXHolepunch>\n" + "\t\t\t<PEXOutgoing>" + p.getPEXOutgoingConnectionFlag() + "</PEXOutgoing>\n" + "\t\t\t<PEXSeed>" + p.getPEXSeedUploadOnlyFlag() + "</PEXSeed>\n" + "\t\t\t<PEXuTP>" + p.getPEXuTPFlag() + "</PEXuTP>\n" + "\t\t</peer>\n";
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Peer is null");
        }
        return "";
    }

    public synchronized boolean containsPeer(String IP) {
        return swarmPeerList.containsKey(IP);
    }
}

