/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PeerCache {
    private int PEER_CACHE_SIZE = 100000;
    private List<Peer> peers = Collections.synchronizedList(new LinkedList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPeer(Peer peer) {
        List<Peer> list = this.peers;
        synchronized (list) {
            this.peers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Peer getPeer() {
        List<Peer> list = this.peers;
        synchronized (list) {
            if (this.peers.size() != 0) {
                return this.peers.remove(0);
            }
            return null;
        }
    }

    public synchronized Peer[] fetchPeerList(int desiredPeerAmount) {
        if (desiredPeerAmount < this.size()) {
            Peer[] peerlist = new Peer[desiredPeerAmount];
            int i = 0;
            while (i < desiredPeerAmount) {
                peerlist[i] = this.getPeer();
                ++i;
            }
            return peerlist;
        }
        Peer[] peerlist = new Peer[this.size()];
        this.peers.toArray(peerlist);
        return peerlist;
    }

    public boolean hasPeers() {
        return this.size() > 0;
    }

    public int size() {
        return this.peers.size();
    }
}

