/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Calendar;

public class Peer {
    private String id;
    private String ip;
    private InetSocketAddress addressPort;
    private int port;
    private boolean interested = false;
    private boolean choked = true;
    private boolean interesting = false;
    private boolean choking = true;
    private BitSet hasPiece;
    private int downloaded = 0;
    private float dlrate = 0.0f;
    private long lastDL = 0L;
    private float ulrate = 0.0f;
    private long lastUL = 0L;
    private int uploaded = 0;
    private boolean connected = false;
    private Calendar discDateTime;
    public boolean PEXEncryptionFlag = false;
    public boolean PEXSeedUploadOnlyFlag = false;
    public boolean PEXuTPFlag = false;
    public boolean PEXHolepunchFlag = false;
    public boolean PEXOutgoingConnectionFlag = false;
    private boolean discDHT = false;
    private boolean discPEX = false;
    private boolean discTracker = false;

    public Peer() {
        this.hasPiece = new BitSet();
    }

    public Peer(String id, String ip, int port) {
        this.lastDL = System.currentTimeMillis();
        this.lastUL = System.currentTimeMillis();
        this.id = id;
        this.ip = ip;
        this.port = port;
        this.hasPiece = new BitSet();
        try {
            this.addressPort = new InetSocketAddress(InetAddress.getByName(this.ip), this.port);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public Peer(InetSocketAddress addressPort) {
        this.addressPort = addressPort;
        this.ip = addressPort.getAddress().getHostAddress();
        this.port = addressPort.getPort();
    }

    public void resetDL() {
        this.dlrate = 0.0f;
        this.lastDL = System.currentTimeMillis();
    }

    public void resetUL() {
        this.ulrate = 0.0f;
        this.lastUL = System.currentTimeMillis();
    }

    public void setDiscDateTime() {
        if (this.discDateTime == null) {
            this.discDateTime = Calendar.getInstance();
        }
    }

    public float getDLRate(boolean reset) {
        if (reset) {
            float tmp = this.dlrate;
            this.dlrate = 0.0f;
            return tmp;
        }
        return this.dlrate;
    }

    public float getULRate(boolean reset) {
        if (reset) {
            float tmp = this.ulrate;
            this.ulrate = 0.0f;
            return tmp;
        }
        return this.ulrate;
    }

    public int getDL() {
        return this.downloaded;
    }

    public Calendar getDiscDateTime() {
        return this.discDateTime;
    }

    public int getUL() {
        return this.uploaded;
    }

    public void setDLRate(int dl) {
        this.dlrate += (float)dl;
        this.downloaded += dl;
    }

    public void setULRate(int ul) {
        this.ulrate += (float)ul;
        this.uploaded += ul;
    }

    public String getID() {
        return this.id;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public BitSet getHasPiece() {
        return this.hasPiece;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setIP(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public boolean isChoked() {
        return this.choked;
    }

    public boolean isInteresting() {
        return this.interesting;
    }

    public boolean isChoking() {
        return this.choking;
    }

    public void setInterested(boolean i) {
        this.interested = i;
    }

    public void setChoked(boolean c) {
        this.choked = c;
    }

    public void setInteresting(boolean i) {
        this.interesting = i;
    }

    public void setChoking(boolean c) {
        this.choking = c;
    }

    public void setHasPiece(byte[] bitfield) {
        boolean[] b = Utils.byteArray2BitArray(bitfield);
        int i = 0;
        while (i < b.length) {
            this.hasPiece.set(i, b[i]);
            ++i;
        }
    }

    public void setHasPiece(int piece, boolean has) {
        this.hasPiece.set(piece, has);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connectionStatus) {
        this.connected = connectionStatus;
    }

    public boolean equals(Peer p) {
        return this.id == p.getID() && this.ip == p.getIP() && this.port == p.getPort();
    }

    public String toString() {
        return String.valueOf(this.ip) + ":" + this.port;
    }

    public void setInetSocketAddress(InetSocketAddress addressPort) {
        this.addressPort = addressPort;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addressPort;
    }

    public void setDHTDiscTrue() {
        this.discDHT = true;
    }

    public void setPEXDiscTrue() {
        this.discPEX = true;
    }

    public void setTrackerDiscTrue() {
        this.discTracker = true;
    }

    public boolean getDHTDisc() {
        return this.discDHT;
    }

    public boolean getPEXDisc() {
        return this.discPEX;
    }

    public boolean getTrackerDisc() {
        return this.discTracker;
    }

    public boolean getPEXEncryptionFlag() {
        return this.PEXEncryptionFlag;
    }

    public boolean getPEXHolepunchFlag() {
        return this.PEXHolepunchFlag;
    }

    public boolean getPEXOutgoingConnectionFlag() {
        return this.PEXOutgoingConnectionFlag;
    }

    public boolean getPEXSeedUploadOnlyFlag() {
        return this.PEXSeedUploadOnlyFlag;
    }

    public boolean getPEXuTPFlag() {
        return this.PEXuTPFlag;
    }

    public void setPEXFlag(String hex) {
        int intValue = Integer.parseInt(hex, 16);
        if (intValue >= 64) {
            System.err.println("Unexpected PEX Flag > 64");
            intValue -= 64;
        }
        if (intValue >= 32) {
            System.err.println("Unexpected PEX Flag > 32");
            intValue -= 32;
        }
        if (intValue >= 16) {
            this.PEXOutgoingConnectionFlag = true;
            intValue -= 16;
        }
        if (intValue >= 8) {
            this.PEXHolepunchFlag = true;
            intValue -= 8;
        }
        if (intValue >= 4) {
            this.PEXuTPFlag = true;
            intValue -= 4;
        }
        if (intValue >= 2) {
            this.PEXSeedUploadOnlyFlag = true;
            intValue -= 2;
        }
        if (intValue >= 16) {
            this.PEXEncryptionFlag = true;
            --intValue;
        }
    }
}

