/*
 * Decompiled with CFR 0.152.
 */
import com.maxmind.geoip.Location;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class MainUDPRequest {
    static PeerCache DHTPeerCache = null;
    static SwarmPeerList swarmPeerList = new SwarmPeerList();
    static String textToDisplay = "";
    static String info_hash = "bb63eb5b61969956e71273026f00a1deca464413";
    static String mapDataName = "";
    static String mapDataAsString = "";

    public String launch(String info_hash_supplied) {
        if (info_hash_supplied != null && !info_hash_supplied.contains("ShareID")) {
            info_hash = info_hash_supplied;
        }
        try {
            DatagramSocket out = new DatagramSocket();
            InetAddress IPAddress = InetAddress.getByName("54.225.196.38");
            byte[] littleMessage = MainUDPRequest.hexStringToByteArray("410037af000306bb00000000001000000d0c0000");
            byte[] data = MainUDPRequest.hexStringToByteArray("010037b00004a527a02edcd4001000000d0d8cc50000006264323a6c61363aac1a6ab37468323a6c7069323938303065313a6d393a6765745f7065657273343a7065657232303a1004551e23cde8c06af241f02624715f769d0a55353a736861726532303a" + info_hash.toLowerCase() + "65");
            DatagramPacket littlePacket = new DatagramPacket(littleMessage, littleMessage.length, IPAddress, 3000);
            DatagramPacket sendPacket = new DatagramPacket(data, data.length, IPAddress, 3000);
            out.send(littlePacket);
            String responseAsHex = "";
            byte[] response = new byte[100];
            DatagramPacket receivePacket = new DatagramPacket(response, response.length);
            out.setSoTimeout(5000);
            out.receive(receivePacket);
            responseAsHex = MainUDPRequest.byteArrayToHexString(receivePacket.getData());
            System.out.println(String.valueOf(responseAsHex) + "\n\n");
            boolean count = false;
            boolean peersReturned = false;
            while (!peersReturned) {
                out.send(sendPacket);
                response = new byte[1800];
                receivePacket = new DatagramPacket(response, response.length);
                out.setSoTimeout(5000);
                out.receive(receivePacket);
                responseAsHex = MainUDPRequest.byteArrayToHexString(receivePacket.getData());
                if (responseAsHex.contains("7065657273")) {
                    peersReturned = true;
                }
                System.out.println(String.valueOf(responseAsHex) + "\n\n");
                count = false;
                Thread.sleep(500L);
            }
            responseAsHex = responseAsHex.substring(responseAsHex.indexOf("7065657273353a") + 14);
            responseAsHex = responseAsHex.substring(responseAsHex.indexOf("7065657273") + 10);
            while (responseAsHex.contains("61363a")) {
                try {
                    int i;
                    responseAsHex = responseAsHex.substring(responseAsHex.indexOf("61363a") + 6);
                    System.out.print("External IP:Port: " + responseAsHex.substring(0, 12));
                    byte[] IPByte = MainUDPRequest.hexStringToByteArray(responseAsHex.substring(0, 8));
                    byte[] portByte = MainUDPRequest.hexStringToByteArray(responseAsHex.substring(8, 12));
                    InetAddress temp = InetAddress.getByAddress(IPByte);
                    System.out.print(" aka: " + temp.getHostAddress() + ":" + Integer.parseInt(Utils.bytesToHex(portByte), 16) + " ");
                    Peer newPeer = new Peer(null, temp.getHostAddress(), 1);
                    String IP = newPeer.getIP();
                    if (!swarmPeerList.containsPeer(IP)) {
                        swarmPeerList.handlePeer(newPeer);
                        if (responseAsHex.contains("7032303a")) {
                            textToDisplay = String.valueOf(textToDisplay) + "External IP: " + temp.getHostAddress() + ":" + Integer.parseInt(Utils.bytesToHex(portByte), 16);
                            int lengthSoFar = textToDisplay.length();
                            i = 0;
                            while (i < 33 - lengthSoFar) {
                                textToDisplay = String.valueOf(textToDisplay) + " ";
                                ++i;
                            }
                        }
                    }
                    responseAsHex = responseAsHex.substring(responseAsHex.indexOf("6c61363a") + 8);
                    System.out.print("Internal IP: " + responseAsHex.substring(0, 12));
                    IPByte = MainUDPRequest.hexStringToByteArray(responseAsHex.substring(0, 8));
                    portByte = MainUDPRequest.hexStringToByteArray(responseAsHex.substring(8, 12));
                    temp = InetAddress.getByAddress(IPByte);
                    System.out.println(" aka:" + temp.getHostAddress() + ":" + Integer.parseInt(Utils.bytesToHex(portByte), 16) + " ");
                    newPeer = new Peer(null, temp.getHostAddress(), 1);
                    IP = newPeer.getIP();
                    if (responseAsHex.contains("7032303a")) {
                        String ipport = String.valueOf(temp.getHostAddress()) + ":" + Integer.parseInt(Utils.bytesToHex(portByte), 16);
                        textToDisplay = String.valueOf(textToDisplay) + "     \tInternal IP: " + ipport;
                        i = 0;
                        while (i < 20 - ipport.length()) {
                            textToDisplay = String.valueOf(textToDisplay) + " ";
                            ++i;
                        }
                        textToDisplay = String.valueOf(textToDisplay) + " ";
                    }
                    System.out.print("  \tPeerID: " + responseAsHex.substring(8, 48));
                    if (!responseAsHex.contains("7032303a")) continue;
                    textToDisplay = String.valueOf(textToDisplay) + "     \tPeerID: " + responseAsHex.substring(8, 48) + "\n";
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            System.out.println("\n\n" + SwarmPeerList.size() + " active Peers found.");
            MainUDPRequest.generateHardcodedWorldMapData();
            return textToDisplay;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static synchronized void parseMapToPeerCache(Map startPeers) {
        byte[] nodes = (byte[])startPeers.get("nodes");
        String nodeID = "";
        int nodePort = 0;
        InetAddress address = null;
        try {
            if (nodes.length % 26 == 0) {
                int i = 0;
                while (i < nodes.length / 26) {
                    byte[] nodeIDArr = new byte[20];
                    byte[] nodeIPArr = new byte[4];
                    byte[] nodePortArr = new byte[2];
                    int nodeIPIndex = 0;
                    int nodePortIndex = 0;
                    int j = 0;
                    while (j < 26) {
                        if (j < 20) {
                            nodeIDArr[j] = nodes[j + i * 26];
                        } else if (j > 19 && j < 24) {
                            nodeIPArr[nodeIPIndex] = nodes[j + i * 26];
                            ++nodeIPIndex;
                        } else if (j > 23) {
                            nodePortArr[nodePortIndex] = nodes[j + i * 26];
                            ++nodePortIndex;
                        }
                        nodeID = Utils.bytesToHex(nodeIDArr).toUpperCase();
                        address = InetAddress.getByAddress(nodeIPArr);
                        nodePort = Integer.parseInt(Utils.bytesToHex(nodePortArr), 16);
                        ++j;
                    }
                    Peer peer = new Peer(new InetSocketAddress(address, nodePort));
                    DHTPeerCache.addPeer(peer);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] generateRandomID() {
        Random ran = new Random();
        String unique1 = Long.toString(Math.abs(ran.nextLong()), 16);
        String unique2 = Long.toString(Math.abs(ran.nextLong()), 16);
        String unique3 = Long.toString(Math.abs(ran.nextLong()), 16);
        String unique4 = Long.toString(Math.abs(ran.nextLong()), 16);
        return MainUDPRequest.hexStringToByteArray((String.valueOf(unique1) + unique2 + unique3 + unique4).substring(0, 40).toUpperCase());
    }

    public static String byteArrayToHexString(byte[] b) throws Exception {
        String result = "";
        int i = 0;
        while (i < b.length) {
            result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String generateHardcodedWorldMapData() {
        mapDataName = "mapdata" + info_hash + System.currentTimeMillis() + ".txt";
        File f = new File(mapDataName);
        System.out.println("Outputting file: " + f.getAbsolutePath());
        try {
            CountryLookup cl = new CountryLookup();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8"));
            Iterator<String> iterator = swarmPeerList.getIterator();
            while (iterator.hasNext()) {
                String curIP = iterator.next();
                Location loc = cl.getLocation(curIP);
                if (loc == null) continue;
                System.out.println(loc.countryName);
                out.write("{svgPath: droppin, zoomLevel: 5, scale: 0.6, alpha: 20, title: \"");
                out.write(String.valueOf(loc.city) + ", " + loc.countryName + ": 1\", latitude: " + loc.latitude + ", ");
                out.write("longitude: " + loc.longitude + ", color:\"#FF0000\"}");
                if (iterator.hasNext()) {
                    out.write(",");
                    out.newLine();
                }
                mapDataAsString = String.valueOf(mapDataAsString) + "{svgPath: droppin, zoomLevel: 5, scale: 0.6, alpha: 20, title: \"";
                mapDataAsString = String.valueOf(mapDataAsString) + loc.city + ", " + loc.countryName + ": 1\", latitude: " + loc.latitude + ", ";
                mapDataAsString = String.valueOf(mapDataAsString) + "longitude: " + loc.longitude + ", color:\"#FF0000\"}";
                if (!iterator.hasNext()) continue;
                mapDataAsString = String.valueOf(mapDataAsString) + ",";
            }
            out.close();
            SFTPinJava SFTP = new SFTPinJava();
            SFTP.upload(mapDataName);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static SwarmPeerList getSwarmPeerList() {
        return swarmPeerList;
    }
}

