/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ContactPeer
extends Thread {
    InetAddress address = null;
    InetSocketAddress addressPort = null;
    int port = 0;
    static String info_hash = "";
    static PeerCache DHTPeerCache;
    private SwarmPeerList swarmPeerList;
    static HashMap peerConnectionCount;

    static {
        peerConnectionCount = new HashMap();
    }

    ContactPeer() {
    }

    ContactPeer(ThreadGroup threadGroup, String threadName, InetSocketAddress addressPort, String info_hash, PeerCache DHTPeerCache, SwarmPeerList swarmPeerList, HashMap peerConnectionCount) {
        super(threadGroup, threadName);
        this.addressPort = addressPort;
        this.address = addressPort.getAddress();
        this.port = addressPort.getPort();
        ContactPeer.info_hash = info_hash;
        ContactPeer.DHTPeerCache = DHTPeerCache;
        this.swarmPeerList = swarmPeerList;
        ContactPeer.peerConnectionCount = peerConnectionCount;
    }

    @Override
    public void run() {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("y", "q");
        byte[] version = ContactPeer.hexStringToByteArray("555403e7");
        query.put("v", version);
        Random ran = new Random();
        String transactionID = Long.toString(Math.abs(ran.nextLong()), 36).substring(0, 3);
        query.put("t", transactionID);
        query.put("q", "get_peers");
        HashMap<String, byte[]> arguments = new HashMap<String, byte[]>();
        arguments.put("id", ContactPeer.generateRandomID());
        arguments.put("info_hash", ContactPeer.hexStringToByteArray(info_hash));
        query.put("a", arguments);
        try {
            byte[] data = BEncoder.encode(query);
            DatagramSocket out = new DatagramSocket();
            DatagramPacket sendPacket = new DatagramPacket(data, data.length, this.address, this.port);
            out.send(sendPacket);
            byte[] response = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(response, response.length);
            out.setSoTimeout(5000);
            out.receive(receivePacket);
            Decrypt decrypt = new Decrypt();
            Map m = decrypt.decrypt(receivePacket.getData());
            Map r = (Map)m.get("r");
            if (r.containsKey("nodes")) {
                ContactPeer.processNodes(r);
            } else {
                Object values = r.get("values");
                ArrayList peerList = new ArrayList();
                if (values instanceof List) {
                    peerList.addAll((List)values);
                    int i = 0;
                    while (i < peerList.size()) {
                        byte[] value = (byte[])peerList.get(i);
                        byte[] IP = new byte[4];
                        int j = 0;
                        while (j < 4) {
                            IP[j] = value[j];
                            ++j;
                        }
                        InetAddress valueAddress = InetAddress.getByAddress(IP);
                        byte[] vport = new byte[]{value[4], value[5]};
                        int valuePort = Integer.parseInt(ContactPeer.byteArrayToHexString(vport), 16);
                        String IPAddress = new InetSocketAddress(valueAddress, valuePort).getAddress().getHostAddress();
                        if (!this.swarmPeerList.containsPeer(IPAddress)) {
                            Peer p = new Peer(new InetSocketAddress(valueAddress, valuePort));
                            p.setDiscDateTime();
                            p.setDHTDiscTrue();
                            this.swarmPeerList.handlePeer(p);
                        }
                        ++i;
                    }
                }
                ContactPeer.sendFindNodes(this.addressPort);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized boolean processNodes(Map r) {
        byte[] nodes = (byte[])r.get("nodes");
        String nodeID = "";
        int nodePort = 0;
        InetAddress address = null;
        InetSocketAddress addressPort = null;
        try {
            if (nodes.length % 26 == 0) {
                int i = 0;
                while (i < nodes.length / 26) {
                    byte[] nodeIDArr = new byte[20];
                    byte[] nodeIPArr = new byte[4];
                    byte[] nodePortArr = new byte[2];
                    int nodeIPIndex = 0;
                    int nodePortIndex = 0;
                    int j = 0;
                    while (j < 26) {
                        if (j < 20) {
                            nodeIDArr[j] = nodes[j + i * 26];
                        } else if (j > 19 && j < 24) {
                            nodeIPArr[nodeIPIndex] = nodes[j + i * 26];
                            ++nodeIPIndex;
                        } else if (j > 23) {
                            nodePortArr[nodePortIndex] = nodes[j + i * 26];
                            ++nodePortIndex;
                        }
                        address = InetAddress.getByAddress(nodeIPArr);
                        nodePort = Integer.parseInt(ContactPeer.byteArrayToHexString(nodePortArr), 16);
                        addressPort = new InetSocketAddress(address, nodePort);
                        nodeID = ContactPeer.byteArrayToHexString(nodeIDArr).toUpperCase();
                        ++j;
                    }
                    Peer p = new Peer(addressPort);
                    if (!peerConnectionCount.containsKey(addressPort)) {
                        DHTPeerCache.addPeer(p);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static synchronized boolean sendFindNodes(InetSocketAddress addressPort) {
        InetAddress IPAddress = addressPort.getAddress();
        int port = addressPort.getPort();
        try {
            DatagramSocket out = new DatagramSocket();
            HashMap<String, Object> query = new HashMap<String, Object>();
            query.put("y", "q");
            byte[] version = ContactPeer.hexStringToByteArray("55544f35");
            query.put("v", version);
            Random ran = new Random();
            String transactionID = "18000000";
            query.put("t", ContactPeer.hexStringToByteArray(transactionID));
            query.put("q", "find_node");
            HashMap<String, byte[]> arguments = new HashMap<String, byte[]>();
            arguments.put("id", ContactPeer.generateRandomID());
            arguments.put("target", ContactPeer.hexStringToByteArray(info_hash));
            query.put("a", arguments);
            byte[] data = BEncoder.encode(query);
            DatagramPacket sendPacket = new DatagramPacket(data, data.length, IPAddress, port);
            out.send(sendPacket);
            byte[] response = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(response, response.length);
            boolean replied = false;
            out.setSoTimeout(500);
            out.receive(receivePacket);
            String responseString = new String(receivePacket.getData());
            Decrypt decrypt = new Decrypt();
            Map m = decrypt.decrypt(receivePacket.getData());
            byte[] t = (byte[])m.get("t");
            String tval = new String((byte[])m.get("t"));
            byte[] v = (byte[])m.get("v");
            byte[] y = (byte[])m.get("y");
            Map r = (Map)m.get("r");
            if (r.containsKey("nodes")) {
                ContactPeer.processNodes(r);
            }
        }
        catch (SocketException e) {
            return false;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static byte[] generateRandomID() {
        Random ran = new Random();
        String unique1 = Long.toString(Math.abs(ran.nextLong()), 16);
        String unique2 = Long.toString(Math.abs(ran.nextLong()), 16);
        String unique3 = Long.toString(Math.abs(ran.nextLong()), 16);
        String unique4 = Long.toString(Math.abs(ran.nextLong()), 16);
        return ContactPeer.hexStringToByteArray((String.valueOf(unique1) + unique2 + unique3 + unique4).substring(0, 40).toUpperCase());
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] b) throws Exception {
        String result = "";
        int i = 0;
        while (i < b.length) {
            result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }
}

