/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class Base32 {
    private static final String Base32_3548 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final String Base32_2932 = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    private static String Base32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static boolean usePadding = false;

    private Base32() {
    }

    public static void setBase32Alphabet(boolean useRfc3548) {
        Base32 = useRfc3548 ? Base32_3548 : Base32_2932;
    }

    public static void usePadding(boolean val) {
        usePadding = val;
    }

    public static String toString(byte[] b) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] s = new byte[5];
        byte[] t = new byte[8];
        int nblocks = (b.length + 4) / 5;
        int i = 0;
        while (i < nblocks) {
            if (i == nblocks - 1) {
                Arrays.fill(s, (byte)0);
            }
            int j = i * 5;
            int k = 0;
            while (k < s.length && j < b.length) {
                s[k] = b[j];
                ++k;
                ++j;
            }
            int block_len = k != s.length ? b.length % 5 : 5;
            int padding = Base32.blockLenToPadding(block_len);
            t[0] = (byte)(s[0] >> 3 & 0x1F);
            t[1] = (byte)((s[0] & 7) << 2 | s[1] >> 6 & 3);
            t[2] = (byte)(s[1] >> 1 & 0x1F);
            t[3] = (byte)((s[1] & 1) << 4 | s[2] >> 4 & 0xF);
            t[4] = (byte)((s[2] & 0xF) << 1 | s[3] >> 7 & 1);
            t[5] = (byte)(s[3] >> 2 & 0x1F);
            t[6] = (byte)((s[3] & 3) << 3 | s[4] >> 5 & 7);
            t[7] = (byte)(s[4] & 0x1F);
            int n = 0;
            while (n < t.length - padding) {
                os.write(Base32.charAt(t[n]));
                ++n;
            }
            if (usePadding) {
                n = t.length - padding;
                while (n < t.length) {
                    os.write(61);
                    ++n;
                }
            }
            ++i;
        }
        return new String(os.toByteArray());
    }

    public static String formatString(byte[] b, int lineLength, String prefix, boolean addClose) {
        String s = Base32.toString(b);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            sb.append(prefix);
            if (i + lineLength >= s.length()) {
                sb.append(s.substring(i));
                if (addClose) {
                    sb.append(" )");
                }
            } else {
                sb.append(s.substring(i, i + lineLength));
                sb.append("\n");
            }
            i += lineLength;
        }
        return sb.toString();
    }

    private static int blockLenToPadding(int block_len) {
        switch (block_len) {
            default: {
                return 0;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: 
        }
        return 1;
    }

    private static int paddingToBlockLen(int chars_of_padding) {
        switch (chars_of_padding) {
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 0: {
                return 5;
            }
        }
        return -1;
    }

    public static byte[] fromString(String str) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        byte[] raw = str.getBytes();
        int i = 0;
        while (i < raw.length) {
            if (!Character.isWhitespace((char)raw[i])) {
                bs.write((byte)Character.toUpperCase((char)raw[i]));
            }
            ++i;
        }
        byte[] in = bs.toByteArray();
        bs.reset();
        DataOutputStream ds = new DataOutputStream(bs);
        short[] s = new short[8];
        int[] t = new int[5];
        int nblocks = (in.length + 7) / 8;
        int i2 = 0;
        while (i2 < nblocks) {
            int block_len;
            if (i2 == nblocks - 1) {
                Arrays.fill(s, (short)0);
            }
            int padding = 0;
            int j = i2 * 8;
            int k = 0;
            while (j < in.length && k < s.length) {
                if (in[j] == 61) {
                    padding = 8 - k;
                    if (in.length % 8 == 0) break;
                    return null;
                }
                s[k] = (short)Base32.indexOf(in[j]);
                if (s[k] < 0) {
                    return null;
                }
                ++j;
                ++k;
            }
            if ((block_len = Base32.paddingToBlockLen(padding = k != s.length ? 8 - k : padding)) < 0) {
                return null;
            }
            t[0] = s[0] << 3 | s[1] >> 2;
            t[1] = (s[1] & 3) << 6 | s[2] << 1 | s[3] >> 4;
            t[2] = (s[3] & 0xF) << 4 | s[4] >> 1 & 0xF;
            t[3] = s[4] << 7 | s[5] << 2 | s[6] >> 3;
            t[4] = (s[6] & 7) << 5 | s[7];
            try {
                j = 0;
                while (j < block_len) {
                    ds.writeByte((byte)(t[j] & 0xFF));
                    ++j;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i2;
        }
        return bs.toByteArray();
    }

    public static void main(String[] args) {
        try {
            int i;
            if (args.length == 1) {
                byte[] out = Base32.fromString(args[0]);
                System.out.print("byte[] exp = { ");
                i = 0;
                while (i < out.length) {
                    int n = out[i] & 0xFF;
                    System.out.print(String.valueOf(n) + ", ");
                    ++i;
                }
                System.out.println("};");
                System.exit(0);
            }
            byte[] in = new byte[args.length];
            i = 0;
            while (i < args.length) {
                in[i] = (byte)(Integer.parseInt(args[i]) & 0xFF);
                ++i;
            }
            String s = Base32.toString(in);
            System.out.println("base 32: " + s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

