/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class BTSyncCrawlerGUI {
    static JFrame frame;
    static MainUDPRequest app;
    static SwarmPeerList peerList;

    static {
        app = new MainUDPRequest();
        peerList = new SwarmPeerList();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BTSyncCrawlerGUI.displayJFrame();
            }
        });
    }

    static void displayJFrame() {
        frame = new JFrame("BTSync Crawler 0.02");
        final JTextField secretField = new JTextField("Please enter ShareID (40 hex chars)");
        secretField.setColumns(40);
        secretField.setFont(new Font("Courier", 0, 14));
        final JButton startCrawlButton = new JButton("Start Crawl");
        final JTextArea textArea = new JTextArea(20, 128);
        textArea.setFont(new Font("Courier", 0, 12));
        JScrollPane scrollPane = new JScrollPane(textArea);
        JLabel contactInfo = new JLabel("Developed by: mark.scanlon@ucd.ie");
        final JButton visualiseButton = new JButton("Visualise Discovered Peers");
        visualiseButton.setVisible(false);
        ImageIcon image = new ImageIcon("./ucdlogosmall.png");
        JLabel ucdLabel = new JLabel(image, 2);
        ucdLabel.setSize(300, 40);
        ucdLabel.setAlignmentX(10.0f);
        startCrawlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String textToDisplay = "";
                startCrawlButton.setText("Crawling...");
                startCrawlButton.setEnabled(false);
                if (secretField.getText().isEmpty() || secretField.getText().length() != 40) {
                    JOptionPane.showMessageDialog(null, "ShareID should be 40 hexadecimal characters.\nContinuing with a topical ShareID...", "Error", 0);
                    textArea.setText("Attempting to locate peers sharing " + secretField.getText());
                    textToDisplay = app.launch(null);
                    peerList = MainUDPRequest.getSwarmPeerList();
                } else {
                    textToDisplay = app.launch(secretField.getText());
                    peerList = MainUDPRequest.getSwarmPeerList();
                }
                if (peerList != null) {
                    textArea.setText(textToDisplay);
                    visualiseButton.setVisible(true);
                    startCrawlButton.setEnabled(true);
                    startCrawlButton.setText("Start Crawl");
                } else {
                    textArea.setText("No Peers Found. Please try again.");
                    startCrawlButton.setEnabled(true);
                    startCrawlButton.setText("Start New Crawl");
                }
            }
        });
        visualiseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://markscanlon.co/map/ares/aresmap.php?file=" + MainUDPRequest.mapDataName);
                    BTSyncCrawlerGUI.openWebpage(url.toURI());
                }
                catch (URISyntaxException ue) {
                    ue.printStackTrace();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        frame.getContentPane().setLayout(new FlowLayout());
        frame.add(ucdLabel);
        frame.add(secretField);
        frame.add(startCrawlButton);
        frame.add(scrollPane);
        frame.add(visualiseButton);
        frame.add(contactInfo);
        frame.setDefaultCloseOperation(3);
        frame.setPreferredSize(new Dimension(920, 350));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

