/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BEncoder {
    public static byte[] encode(Map object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new BEncoder().encode(baos, object);
        return baos.toByteArray();
    }

    private void encode(ByteArrayOutputStream baos, Object object) throws IOException {
        if (object instanceof String || object instanceof Float) {
            String tempString = object instanceof String ? (String)object : String.valueOf((Float)object);
            ByteBuffer bb = Constants.DEFAULT_CHARSET.encode(tempString);
            this.write(baos, Constants.DEFAULT_CHARSET.encode(String.valueOf(bb.limit())));
            baos.write(58);
            this.write(baos, bb);
        } else if (object instanceof Map) {
            Map tempMap = (Map)object;
            TreeMap tempTree = null;
            boolean byte_keys = false;
            baos.write(100);
            tempTree = tempMap instanceof TreeMap ? (TreeMap)tempMap : new TreeMap(tempMap);
            for (Map.Entry entry : tempTree.entrySet()) {
                Object o_key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                if (o_key instanceof byte[]) {
                    this.encode(baos, (byte[])o_key);
                    this.encode(baos, value);
                    continue;
                }
                String key = (String)o_key;
                if (byte_keys) {
                    try {
                        this.encode(baos, Constants.BYTE_CHARSET.encode(key));
                        this.encode(baos, tempMap.get(key));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IOException("BEncoder: unsupport encoding: " + e.getMessage());
                    }
                }
                this.encode(baos, key);
                this.encode(baos, value);
            }
            baos.write(101);
        } else if (object instanceof List) {
            List tempList = (List)object;
            baos.write(108);
            int i = 0;
            while (i < tempList.size()) {
                this.encode(baos, tempList.get(i));
                ++i;
            }
            baos.write(101);
        } else if (object instanceof Long) {
            Long tempLong = (Long)object;
            baos.write(105);
            this.write(baos, Constants.DEFAULT_CHARSET.encode(tempLong.toString()));
            baos.write(101);
        } else if (object instanceof Integer) {
            Integer tempInteger = (Integer)object;
            baos.write(105);
            this.write(baos, Constants.DEFAULT_CHARSET.encode(tempInteger.toString()));
            baos.write(101);
        } else if (object instanceof byte[]) {
            byte[] tempByteArray = (byte[])object;
            this.write(baos, Constants.DEFAULT_CHARSET.encode(String.valueOf(tempByteArray.length)));
            baos.write(58);
            baos.write(tempByteArray);
        } else if (object instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)object;
            this.write(baos, Constants.DEFAULT_CHARSET.encode(String.valueOf(bb.limit())));
            baos.write(58);
            this.write(baos, bb);
        }
    }

    protected void write(OutputStream os, ByteBuffer bb) throws IOException {
        os.write(bb.array(), 0, bb.limit());
    }

    private static boolean objectsAreIdentical(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Integer) {
            o1 = new Long(((Integer)o1).longValue());
        }
        if (o2 instanceof Integer) {
            o2 = new Long(((Integer)o2).longValue());
        }
        if (o1 instanceof Float) {
            o1 = String.valueOf((Float)o1);
        }
        if (o2 instanceof Float) {
            o2 = String.valueOf((Float)o2);
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (o1 instanceof Long) {
            return o1.equals(o2);
        }
        if (o1 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof ByteBuffer) {
            return o1.equals(o2);
        }
        if (o1 instanceof String) {
            return o1.equals(o2);
        }
        if (o1 instanceof List) {
            return BEncoder.listsAreIdentical((List)o1, (List)o2);
        }
        if (o1 instanceof Map) {
            return BEncoder.mapsAreIdentical((Map)o1, (Map)o2);
        }
        System.err.println("Invalid type: " + o1);
        return false;
    }

    public static boolean listsAreIdentical(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            if (!BEncoder.objectsAreIdentical(list1.get(i), list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean mapsAreIdentical(Map map1, Map map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Object key : map1.keySet()) {
            Object v2;
            Object v1 = map1.get(key);
            if (BEncoder.objectsAreIdentical(v1, v2 = map2.get(key))) continue;
            return false;
        }
        return true;
    }
}

