-- #############################
-- # BSYNC - Outbound
-- #############################

local proto_bping = Proto("bping","BTSYNC KEEPALIVE")
function proto_bping.dissector(buffer, pinfo, tree)
pinfo.cols.protocol = "BTSYNC KEEPALIVE"
	local subtree = tree:add(proto_bping,buffer(),"BTSYNC KEEPALIVE")
	subtree:add(buffer:len(),"The buffer length " .. buffer:len())
	--print('BSYNC PING', tostring(tvb))
end


-- ###############################
-- # BTSYNC - Inbound
-- ###############################

local proto_bpong = Proto("bpong","BTSYNC uTP")
function proto_bpong.dissector(buffer, pinfo, tree)
if tostring(buffer(0,2)) == "2100" then
pinfo.cols.protocol = "BTSYNC ACK"
	local subtree = tree:add(proto_bpong,buffer(),"BTSYNC ACK")
	subtree:add(buffer:len(),"The buffer length " .. buffer:len())
	subtree:add("uTP Type: Selective ACK ")
	subtree:add("Local Transaction ID: " .. buffer(2,2):uint())
	subtree:add("Remote transaction ID:" .. buffer(4,2):uint())
	subtree:add("Local Counter :" .. buffer(16,2):uint())
	subtree:add("Remote Counter :" .. buffer(18,2):uint())
	--print('BSYNC PONG', tostring(buffer))
elseif tostring(buffer(0,2)) == "0100" then
	pinfo.cols.protocol = "BTSYNC KEEPALIVE"
	local subtree = tree:add(proto_bpong,buffer(),"BTSYNC KEEPALIVE")
	subtree:add(buffer:len(),"The buffer length " .. buffer:len())
	subtree:add("uTP Type: Heartbeat")
	subtree:add("Local Transaction ID: " .. buffer(2,2):uint())
	subtree:add("Remote transaction ID:" .. buffer(4,2):uint())
	subtree:add("Local Counter :" .. buffer(16,2):uint())
	subtree:add("Remote Counter :" .. buffer(18,2):uint())
--elsif tostring(buffer(0,2))== "1000" then
	--pinfo.cols.protocol = "BTSYNC KEEPALIVE"
	--local subtree = tree:add(proto_bping,buffer(),"BTSYNC KEEPALIVE")
	--subtree:add(buffer:len(),"The buffer length " .. buffer:len())
elseif tostring(buffer(0,2)) == "3100" then
	pinfo.cols.protocol = "BTSYNC RST"
	local subtree = tree:add(proto_bpong,buffer(),"BTSYNC RST")
	subtree:add(buffer:len(),"The buffer length " .. buffer:len())
	subtree:add("uTP Type: Reset" )
	subtree:add("Local Transaction ID: " .. buffer(2,2):uint())
	subtree:add("Remote transaction ID:" .. buffer(4,2):uint())
	subtree:add("Local Counter :" .. buffer(16,2):uint())
	subtree:add("Remote Counter :" .. buffer(18,2):uint())
--elsif tostring(buffer(0,2))== "3100" then
	--pinfo.cols.protocol = "BTSYNC RST"
	--local subtree = tree:add(proto_bping,buffer(),"BTSYNC RST")
	--subtree:add(buffer:len(),"The buffer length " .. buffer:len())
elseif tostring(buffer(0,2)) == "4100" then
	pinfo.cols.protocol = "BTSYNC SYN"
	local subtree = tree:add(proto_bpong,buffer(),"BTSYNC SYN")
	subtree:add(buffer:len(),"The buffer length " .. buffer:len())
	subtree:add("uTP Type: SYN / INIT")
	subtree:add("Local Transaction ID: " .. buffer(2,2):uint())
	subtree:add("Remote transaction ID:" .. buffer(4,2):uint())
	subtree:add("Local Counter :" .. buffer(16,2):uint())
	subtree:add("Remote Counter :" .. buffer(18,2):uint())
--elsif tostring(buffer(0,2))== "4100" then
	--pinfo.cols.protocol = "BTSYNC SYN"
	--local subtree = tree:add(proto_bping,buffer(),"BTSYNC SYN")
	--subtree:add(buffer:len(),"The buffer length " .. buffer:len())
else
	error("undefined packet")
end
end


-- ###############################
-- # BSYNC - GET_PEERS
-- ###############################

local proto_bsyncgp = Proto("bsyncgp","BTSYNC GET_PEERS")
function proto_bsyncgp.dissector(buffer, pinfo, tree)


if tostring(buffer(0,5)) == "4253594e43" then
	pinfo.cols.protocol = "BTSYNC GET_PEERS"
		local subtree = tree:add(proto_bsyncgp,buffer(),"BTSYNC PEER REQ")
	--IP address Hex to dotted quad : port pair setup.
	local ep1 = tostring((buffer(13,1):uint()))
	local ep2 = tostring((buffer(14,1):uint()))
	local ep3 = tostring((buffer(15,1):uint()))
	local ep4 = tostring((buffer(16,1):uint()))
	local epp = tostring((buffer(17,2):uint()))
	subtree:add("Requesting Peer: " .. ep1 .. "." .. ep2 .. "." .. ep3 .. "." .. ep4 .. ":" .. epp)
	--subtree:add("f value :" .. (string.find(aport, "[:alpha:]") - 3))
	--subtree:add("h value " .. actport)
	--subtree:add("New P " .. p)
	subtree:add("PeerID: " .. buffer(42,20))
	subtree:add("ShareID: " .. buffer(73,20))
	
	--print('BSYNC GET PEER REQUEST', tostring(buffer))
	
else
	pinfo.cols.protocol = "BTSYNC GET_PEERS"
-- set up subtree and local variables
	local subtree = tree:add(proto_bsyncgp,buffer(),"BTSYNC PEER REQ")
	--IP address Hex to dotted quad : port pair setup.
	local ep1 = tostring((buffer(31,1):uint()))
	local ep2 = tostring((buffer(32,1):uint()))
	local ep3 = tostring((buffer(33,1):uint()))
	local ep4 = tostring((buffer(34,1):uint()))
	local epp = tostring((buffer(35,2):uint()))
	--Extract and confirm registered port (for some reason)
	local aport = buffer(42,9):string()
	-- we need to start our conter because everything is variable from here
	local p = 42
	-- returns lots up to the next label. we need to go as far as the next : and back 2
	local s = (string.find(aport, "[:alpha:]") - 3)
	--now our port is a string
	local actport = buffer(42,(s)):string()
	--update our counter to the end of the port string
	local p = p + s 
	--local estring = print(string.find(s, "[:alpha:]"))
	--local p = 37
	--local f, h = string.find(aport, "e")
	--local starti = print(f, h)
	--local endi = print(h)
	
	--#####pseudo stuff#########
	--while byte != e do
	--read byte buffer(p,1) and add to array
	-- p = p+1
	
	--local aport = buffer(41,10):string()
	subtree:add("Requesting Peer: " .. ep1 .. "." .. ep2 .. "." .. ep3 .. "." .. ep4 .. ":" .. epp)
	subtree:add("Advertised Port :" .. actport)
	--subtree:add("f value :" .. (string.find(aport, "[:alpha:]") - 3))
	--subtree:add("h value " .. actport)
	--subtree:add("New P " .. p)
	subtree:add("PeerID: " .. buffer((p+24),20))
	subtree:add("ShareID: " .. buffer((p+54),20))
	
	--print('BSYNC GET PEER REQUEST', tostring(buffer))
end

end

-- ###############################
-- # IP Address/ Port block
-- ###############################
--function IPv4(IPArray, PortArray)
	

-- ###############################
-- # BSYNC - PEERS
-- ###############################

local proto_bspeer = Proto("bspeer","BTSYNC PEER LIST")
function proto_bspeer.dissector(buffer, pinfo, tree)

if tostring(buffer(0,5)) == "4253594e43" then
	pinfo.cols.protocol = "BTSYNC TRACKER RESPONSE"
	-- 2 trees. Tree 1 will give packet data , tree 2 gives peer details
	local subtree = tree:add(proto_bspeer,buffer(),"BTSYNC PEERS")
	--plist is the length of the frame -header and footer. just the peers data. Each Peer takes up 51 bytes of space + padding and labels
	local plist = (buffer:len() - 84)
	local t = tree:add( proto_bspeer, buffer() )
	-- number of bytes to the start of the Peers dictionary (data header + dictionary headers)
	local i = 40
	-- not used but may be useful, start of the Data footer, end of the Peer dictionary escapes (ee)
	local startend = (buffer:len() - 50)
	--Debug stuff used for reporting packet details that are not really relevant in the end product
	--subtree:add("The buffer length " .. buffer:len())
	--subtree:add("The packet Header" .. buffer(0,24))
	--subtree:add("Start of Dictionary" .. buffer(25,3))
	
	--External IP address Byte to dotted quad building block. ABCDEE.
	local ep1 = tostring((buffer(13,1):uint()))
	local ep2 = tostring((buffer(14,1):uint()))
	local ep3 = tostring((buffer(15,1):uint()))
	local ep4 = tostring((buffer(16,1):uint()))
	local epp = tostring((buffer(17,2):uint()))
	
	--timestamp is stored at the end of the packet data in Ascii charcode (30, 31, 32, etc) . converts to a string here for display later
	local tstamp = buffer((buffer:len() - 12),10):string()
	
	--each peer takes up 47 bytes. Only want whole numbers here so we divide plist by 47 and drop any fractions
	local npeers =  tonumber(("%.0f"):format(( plist / 51)))
	
	--External IP (1st IP listed with ea6: , before peer dictionary). ABCDEE becomes A.B.C.D:EE
	subtree:add("Requesting Peer: " .. ep1 .. "." .. ep2 .. "." .. ep3 .. "." .. ep4 .. ":" .. epp)
	
	--ShareID = Sha1 of some function of the share secret. stored after the peer list. 
	subtree:add("Share ID: " .. buffer((buffer:len() - 39),20))
	
	--Display of timestamp stringified earlier
	subtree:add("Timestamp: " .. tstamp)
	
	--the result of the local npeers above
	subtree:add("Number of Peers " .. npeers)
	
	--while loop to iterate through the peer list and extract peer data for display. These are added to the main tree.
	while i + 50 < (buffer:len()) do
		local ip1 = tostring((buffer((i+3),1):uint()))
		local ip2 = tostring((buffer((i+4),1):uint()))
		local ip3 = tostring((buffer((i+5),1):uint()))
		local ip4 = tostring((buffer((i+6),1):uint()))
		local ipp = tostring((buffer((i+7),2):uint()))
		local iip1 = tostring((buffer((i+15),1):uint()))
		local iip2 = tostring((buffer((i+16),1):uint()))
		local iip3 = tostring((buffer((i+17),1):uint()))
		local iip4 = tostring((buffer((i+18),1):uint()))
		local iipp = tostring((buffer((i+19),2):uint()))
		--local pid = tostring((buffer((i+26),20):uint()))
		t:add("External IP: " .. ip1 .. "." .. ip2 .. "." .. ip3 .. "." .. ip4 .. ":" .. ipp)
		t:add("Internal IP: " .. iip1 .. "." .. iip2 .. "." .. iip3 .. "." .. iip4 .. ":" .. iipp)
		t:add("PeerID: " .. buffer((i+27),20))
			--if tostring(buffer(0,5):string()) == "4253594e43" then
			--if tostring(buffer(0,5)) == "4253594e43" then
			--t:add("Start: " .. buffer(0,5))
			--else
			--t:add(tostring(buffer(0,2)))
			--end
		i = i + 51
	end
	
else

pinfo.cols.protocol = "BTSYNC TRACKER RESPONSE"
-- 2 trees. Tree 1 will give packet data , tree 2 gives peer details
local subtree = tree:add(proto_bspeer,buffer(),"BTSYNC PEERS")
--plist is the length of the frame -header and footer. just the peers data. Each Peer takes up 51 bytes of space + padding and labels
local plist = (buffer:len() - 106)
local t = tree:add( proto_bspeer, buffer() )
-- number of bytes to the start of the Peers dictionary (data header + dictionary headers)
local i = 58
-- not used but may be useful, start of the Data footer, end of the Peer dictionary escapes (ee)
local startend = (buffer:len() - 50)
--Debug stuff used for reporting packet details that are not really relevant in the end product
--subtree:add("The buffer length " .. buffer:len())
--subtree:add("The packet Header" .. buffer(0,24))
--subtree:add("Start of Dictionary" .. buffer(25,3))
	
--External IP address Byte to dotted quad building block. ABCDEE.
local ep1 = tostring((buffer(31,1):uint()))
local ep2 = tostring((buffer(32,1):uint()))
local ep3 = tostring((buffer(33,1):uint()))
local ep4 = tostring((buffer(34,1):uint()))
local epp = tostring((buffer(35,2):uint()))
	
--timestamp is stored at the end of the packet data in Ascii charcode (30, 31, 32, etc) . converts to a string here for display later
local tstamp = buffer((buffer:len() - 12),10):string()
	
--each peer takes up 47 bytes. Only want whole numbers here so we divide plist by 47 and drop any fractions
local npeers =  tonumber(("%.0f"):format(( plist / 47)))
	
--External IP (1st IP listed with ea6: , before peer dictionary). ABCDEE becomes A.B.C.D:EE
subtree:add("Requesting Peer: " .. ep1 .. "." .. ep2 .. "." .. ep3 .. "." .. ep4 .. ":" .. epp)
	
--ShareID = Sha1 of some function of the share secret. stored after the peer list. 
subtree:add("Share ID: " .. buffer((buffer:len() - 39),20))
	
--Display of timestamp stringified earlier
subtree:add("Timestamp: " .. tstamp)
	
--the result of the local npeers above
subtree:add("Number of Peers: " .. npeers)
	
--while loop to iterate through the peer list and extract peer data for display. These are added to the main tree.
while i + 51 < (buffer:len()) do
	local ip1 = tostring((buffer((i+3),1):uint()))
	local ip2 = tostring((buffer((i+4),1):uint()))
	local ip3 = tostring((buffer((i+5),1):uint()))
	local ip4 = tostring((buffer((i+6),1):uint()))
	local ipp = tostring((buffer((i+7),2):uint()))
	local iip1 = tostring((buffer((i+15),1):uint()))
	local iip2 = tostring((buffer((i+16),1):uint()))
	local iip3 = tostring((buffer((i+17),1):uint()))
	local iip4 = tostring((buffer((i+18),1):uint()))
	local iipp = tostring((buffer((i+19),2):uint()))
	--local pid = tostring((buffer((i+26),20):uint()))
	t:add("External IP: " .. ip1 .. "." .. ip2 .. "." .. ip3 .. "." .. ip4 .. ":" .. ipp)
	t:add("Internal IP: " .. iip1 .. "." .. iip2 .. "." .. iip3 .. "." .. iip4 .. ":" .. iipp)
	t:add("PeerID: " .. buffer((i+27),20))
	i = i + 51
end
	
end

end

-- bsync protocol example
-- declare our protocol
proto_bsync = Proto("bsync","BitTorrent Sync Protocol")
-- create a function to dissect it
function proto_bsync.dissector(buffer,pinfo,tree)
--pinfo.cols.protocol = "BSYNC Tracker"
	--local subtree = tree:add(bsync_proto,buffer(),"Trivial Protocol Data")
	--subtree:add(buffer:len(),"The buffer length " .. buffer:len())
	if buffer:len()<= 45 then
		--print(buffer:len())
		Dissector.get("bpong"):call(buffer():tvb(), pinfo, tree)
	--elseif buffer:len()== 20 then
		--Dissector.get("bpong"):call(buffer():tvb(), pinfo, tree)
	elseif buffer:len()>= 80 and buffer:len()<= 129 then
		Dissector.get("bsyncgp"):call(buffer():tvb(), pinfo, tree)
	elseif buffer:len()>= 130 then
		Dissector.get("bspeer"):call(buffer():tvb(), pinfo, tree)
	else
		error("undefined packet")
	end

end




--	subtree:add(buffer(0,2),"The first two bytes: " .. buffer(0,2):uint())
--   pinfo.cols.protocol = "BSYNC Tracker"
--    local subtree = tree:add(bsync_proto,buffer(),"Trivial Protocol Data")
--    subtree:add(buffer(0,2),"The first two bytes: " .. buffer(0,2):uint())
--    subtree = subtree:add(buffer(2,2),"The next two bytes")
--    subtree:add(buffer(2,1),"The 3rd byte: " .. buffer(2,1):uint())
--    subtree:add(buffer(3,1),"The 4th byte: " .. buffer(3,1):uint())
--end
-- load the udp.port table
udp_table = DissectorTable.get("udp.port")
-- register our protocol to handle udp port 3000
udp_table:add(3000,proto_bsync)